% File name : kwms.cls
% kwms2012@gmail.com
% 
% This is the official LaTeX class for authors of the KWMS international conference and
% can be obtained at http://kwms.or.kr.
% 

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{kwms}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\ProcessOptions\relax
\LoadClass[a4paper,11pt,twoside,reqno]{amsart}
\usepackage{times}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% J. KWMS printing size 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\topmargin 1.5cm
\footskip 0.9cm
\textwidth 145mm
\evensidemargin 4mm
\oddsidemargin\evensidemargin
\textheight 19.1cm
\marginparwidth 0pt
\pagestyle{myheadings}
\baselineskip 14pt


%\setcounter{footnote}{0}
%\renewcommand{\thefootnote}{\fnsymbol{footnote}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% First and Last Page Format : authors on the first page
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Adding KWMS LOGO and defining title section
%
\def\@maketitle{%
% KWMS LOGO (Added) -------------------------------------------------
\vspace*{-0.35in} \noindent 2025 The 19th KWMS International Conference
%{\makeatletter \start@page--\end@page}, \currentyear 
\vspace{0.35in}
% --------------------------------------------------------------------
  \normalfont\normalsize
  %\@adminfootnotes
  \@mkboth{\@nx\shortauthors}{\@nx\shorttitle}%
  \global\topskip42\p@\relax % 5.5pc   "   "   "     "     "
  \@settitle
  \ifx\@empty\authors \else \@setauthors \fi
%  \ifx\@empty\addresses \else \@setaddresses \fi
  \ifx\@empty\@dedicatory
  \else
    \baselineskip18\p@
    \vtop{\centering{\footnotesize\itshape\@dedicatory\@@par}%
      \global\dimen@i\prevdepth}\prevdepth\dimen@i
  \fi
  \@setabstract
  \normalsize
  \if@titlepage
    \newpage
  \else
    \dimen@34\p@ \advance\dimen@-\baselineskip
    \vskip\dimen@\relax
  \fi
} % end \@maketitle
